/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.fishingmadebetter.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.IEventListener;
import net.minecraftforge.fml.common.eventhandler.ListenerList;
import net.theawesomegem.fishingmadebetter.proxy.CommonProxy;
import org.apache.logging.log4j.Level;

public class HandlerUtil {
    private static HandlerUtil instance;
    private final Class c_EventBus = Class.forName("net.minecraftforge.fml.common.eventhandler.EventBus");
    private final Field f_listeners = this.c_EventBus.getDeclaredField("listeners");
    private final Field f_busID;

    public HandlerUtil() throws Exception {
        this.f_listeners.setAccessible(true);
        this.f_busID = this.c_EventBus.getDeclaredField("busID");
        this.f_busID.setAccessible(true);
    }

    @Nullable
    public static Object findAndRemoveHandlerFromEventBus(String name, @Nullable String specific) throws Exception {
        boolean criticalCrash = false;
        try {
            if (instance == null) {
                instance = new HandlerUtil();
            }
            boolean found_listener = false;
            ConcurrentHashMap listeners = (ConcurrentHashMap)HandlerUtil.instance.f_listeners.get(MinecraftForge.EVENT_BUS);
            Object handler = null;
            for (Map.Entry listener_entry : listeners.entrySet()) {
                handler = listener_entry.getKey();
                String handlerName = handler.getClass().getName();
                if (handlerName.equals("java.lang.Class")) {
                    handlerName = ((Class)handler).getName();
                }
                if (!handlerName.equals(name)) continue;
                found_listener = true;
                if (specific == null) {
                    MinecraftForge.EVENT_BUS.unregister(handler);
                    CommonProxy.Logger.log(Level.INFO, "Found and removed " + name + " from the event bus");
                    return handler;
                }
                ArrayList eventListeners = (ArrayList)listener_entry.getValue();
                Iterator elIterator = eventListeners.iterator();
                while (elIterator.hasNext()) {
                    IEventListener eventListener = (IEventListener)elIterator.next();
                    if (!eventListener.toString().contains(specific)) continue;
                    criticalCrash = true;
                    elIterator.remove();
                    int busID = HandlerUtil.instance.f_busID.getInt(MinecraftForge.EVENT_BUS);
                    ListenerList.unregisterAll((int)busID, (IEventListener)eventListener);
                    CommonProxy.Logger.log(Level.INFO, "Found and removed " + name + " IEventListener " + specific + " from the event bus");
                    return eventListener;
                }
            }
            return null;
        }
        catch (Exception e) {
            if (criticalCrash) {
                throw new RuntimeException(e);
            }
            throw e;
        }
    }
}

